var browser = browser || chrome;
function mr_extension(settings) {
    //console.log(settings);

    var mindrender_domain = "https://mindrender.ai";
    function isMatch(url, pattern) {
        const escapedPattern = pattern.replace(/[-\/\\^$+?.()|[\]{}]/g, '\\$&');
        const regexPattern = '^' + escapedPattern.replace(/\*/g, '.*') + '$';
        const regex = new RegExp(regexPattern);
        return regex.test(url);
    }
    function checkurl() {
        var check = false;
        settings.sites.forEach(site => {
            if (location.href.toLowerCase().indexOf(site.domain.toLowerCase()) >= 0) {
                check = true;
            }
            /*
            site.medias.forEach(media => {
                if (isMatch(location.href, media.url)) {
                    check = true;
                }
            });
            */
        });
        return check;
    }
    function replaceimagedata(s) {
        settings.icons.forEach(icon => {
            s = s.split("[" + icon.name + "]").join(icon.dataurl);
        })
        return s;
    }
    function makestyle() {
        if (document.querySelector("#mr_main_style")) {
            document.querySelector("#mr_main_style").remove();
        }
        var style = document.createElement("style");
        style.id = "mr_main_style";
        var sa = [];
        settings.templates.css.forEach(s => {
            sa.push(replaceimagedata(s));
        });
        style.innerHTML = sa.join("\r\n");
        document.body.appendChild(style);
    }
    function sendmessage(imgdata, sitename) {
        browser.runtime.sendMessage({
            "to": mindrender_domain + "/workspace",
            "name": sitename,
            "from": location.href,
            "imgdata": imgdata,
            "action": "send"
        });
    }
    function sendimageurl(imgurl, sitename) {
        browser.runtime.sendMessage({
            "to": mindrender_domain + "/workspace",
            "name": sitename,
            "from": location.href,
            "imgurl": imgurl,
            "action": "send"
        });
    }
    function loadimg(url, callback) {
        const xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'blob';
        xhr.onload = () => {
            if (xhr.status === 200) {
                const blob = new Blob([xhr.response]);
                const imgUrl = URL.createObjectURL(blob);
                callback(imgUrl);
            }
        };
        xhr.send();
    }
    if (checkurl()) {
        makestyle();
        setInterval(function () {
            settings.sites.forEach(site => {
                site.medias.forEach(media => {
                    if (isMatch(location.href, media.url)) {
                        document.querySelectorAll(media.media_container_selector).forEach(media_container => {
                            let media_element = media_container.querySelector(media.media_selector.query);
                            if (!media_element) {
                                return;
                            }
                            let media_url = media_element.getAttribute(media.media_selector.attribute);
                            let button_container;
                            if (media.button_container.query == "media_container") {
                                button_container = media_container;
                            } else {

                                button_container = media_container.querySelector(media.button_container.query);
                            }
                            if (!button_container) {
                                return;
                            }
                            var find = false;
                            if (media.type == "img") {
                                if (button_container.querySelector(".mr_sendmessage_btn")) {
                                    find = true;
                                }
                            } else if (media.type == "video") {
                                if (button_container.querySelector(".mr_capture_btn")) {
                                    find = true;
                                }
                            }
                            if (!find) {
                                var style = document.createElement("style");
                                var sa = [];
                                media.style.forEach(s => {
                                    sa.push(replaceimagedata(s));
                                });
                                style.innerHTML = sa.join("\r\n");
                                document.body.appendChild(style);

                                let button = document.createElement("div");
                                if (media.button_container.put == "append") {
                                    button_container.appendChild(button);
                                } else if (media.button_container.put == "prepend") {
                                    button_container.prepend(button);
                                } else if (Number(media.button_container.put) > 0) {
                                    let next_element = button_container.childNodes[Number(media.button_container.put)];
                                    if (next_element) {
                                        button_container.insertBefore(button, next_element);
                                    } else {
                                        button_container.appendChild(button);
                                    }
                                }
                                if (media.type == "img") {
                                    button.outerHTML = settings.templates.sendmessage_btn_html;
                                } else if (media.type == "video") {
                                    button.outerHTML = settings.templates.capture_btn_html;
                                }

                                if (media.type == "img") {
                                    button = button_container.querySelector(".mr_sendmessage_btn");
                                    if (media.button_container.style) {
                                        button.setAttribute("style", media.button_container.style);
                                    }
                                    button.addEventListener("click", function () {
                                        media_element = media_container.querySelector(media.media_selector.query);
                                        if(media_element){
                                            media_url = media_element.getAttribute(media.media_selector.attribute);
                                            if(media.media_selector.reload){
                                                sendimageurl(media_url, site.name);
                                            }else{
                                                var img = document.createElement("img");
                                                img.setAttribute("crossorigin", "anonymous");
                                                img.addEventListener("load", function () {
                                                    var canvas = document.createElement("canvas");
                                                    canvas.width = img.naturalWidth;
                                                    canvas.height = img.naturalHeight;
                                                    var ctx = canvas.getContext("2d");
                                                    ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
                                                    var imgdata = canvas.toDataURL("image/jpeg", 1);
                                                    sendmessage(imgdata, site.name);
                                                });
        
                                                img.src = media_url;
                                            }
                                            
                                        }
                                        
                                        /*
                                                                                
                                        
                                        */
                                    });
                                } else if (media.type == "video") {
                                    button = button_container.querySelector(".mr_capture_btn");
                                    if (media.button_container.style) {
                                        button.setAttribute("style", media.button_container.style);
                                    }
                                    var captures = [];
                                    var inv;
                                    var counter = button.querySelector(".mr_capture_counter");
                                    media_element.setAttribute("crossorigin", "anonymous");
                                    //media_element.outerHTML=media_element.outerHTML+" ";
                                    //media_element=media_container.querySelector(media.media_selector.query);
                                    if(media.media_selector.reload){
                                        media_element.load();
                                        media_element.play();
                                    }
                                    
                                    button.addEventListener("mousedown", function () {
                                        captures = [];
                                        counter.innerHTML == "";
                                        var canvas = document.createElement("canvas");
                                        canvas.width = media_element.videoWidth;
                                        canvas.height = media_element.videoHeight;
                                        var ctx = canvas.getContext("2d");
                                        inv = setInterval(function () {
                                            if (captures.length < media.capture_max) {
                                                ctx.drawImage(media_element, 0, 0, canvas.width, canvas.height);
                                                captures.push(canvas.toDataURL("image/jpeg", 1));
                                                counter.style.display = "block";
                                                counter.innerHTML = captures.length;
                                            } else {
                                                showcaptures();
                                            }
                                        }, Math.round(1000 / media.capture_rate));
                                    });
                                    button.addEventListener("mouseup", function () {
                                        showcaptures();
                                    });
                                    function showcaptures() {
                                        clearInterval(inv);
                                        counter.style.display = "none";
                                        if (captures.length == 0) {
                                            var canvas = document.createElement("canvas");
                                            canvas.width = media_element.videoWidth;
                                            canvas.height = media_element.videoHeight;
                                            var ctx = canvas.getContext("2d");
                                            ctx.drawImage(media_element, 0, 0, canvas.width, canvas.height);
                                            sendmessage(canvas.toDataURL("image/jpeg", 1), site.name);
                                        } else {
                                            var mr_captures_div = document.createElement("div");
                                            document.body.appendChild(mr_captures_div);
                                            mr_captures_div.outerHTML = settings.templates.capture_view_html;
                                            mr_captures_div = document.querySelector(".mr_captures_div");
                                            var mr_captures_div_imglist = mr_captures_div.querySelector(".mr_captures_div_imglist");
                                            var mr_captures_div_imgview = mr_captures_div.querySelector(".mr_captures_div_imgview");
                                            var mr_captures_div_close = mr_captures_div.querySelector(".mr_captures_div_close");
                                            mr_captures_div_close.addEventListener("click", function (e) {
                                                e.currentTarget.parentElement.remove();
                                            });
                                            for (let i = 0; i < captures.length; i++) {
                                                var img = document.createElement("img");
                                                img.src = captures[i];
                                                img.addEventListener("click", function (e) {
                                                    if (e.currentTarget.parentElement.querySelector(".select")) {
                                                        e.currentTarget.parentElement.querySelector(".select").className = "";
                                                    }
                                                    e.currentTarget.className = "select";
                                                    mr_captures_div_imgview.innerHTML = "";
                                                    var viewimg = document.createElement("img");
                                                    viewimg.src = e.currentTarget.src;
                                                    mr_captures_div_imgview.appendChild(viewimg);
                                                    var btn = document.createElement("div");
                                                    btn.className = "mr_sendmessage_btn mr_sendmessage_btn_site";
                                                    btn.addEventListener("click", function (be) {
                                                        sendmessage(be.currentTarget.parentElement.querySelector("img").src, site.name);
                                                    });
                                                    mr_captures_div_imgview.appendChild(btn);
                                                });
                                                mr_captures_div_imglist.appendChild(img);
                                            }

                                        }
                                    }
                                }
                            }
                        });
                    }
                });
            });
        }, 1000);
    }
    browser.runtime.onMessage.addListener((message, sender, sendResponse) => {
        if (message.action == "show_supported") {
            makestyle();
            var mr_supported_div = document.createElement("div");
            document.body.appendChild(mr_supported_div);
            mr_supported_div.outerHTML = settings.templates.supported_websites;
            mr_supported_div = document.querySelector(".mr_supported_div");
            var mr_supported_list = mr_supported_div.querySelector(".mr_supported_list");
            var mr_supported_update = mr_supported_div.querySelector(".mr_supported_update");
            var mr_supported_update_text = mr_supported_update.innerHTML;
            var mr_supported_h1 = mr_supported_div.querySelector(".mr_supported_h1");
            var mr_supported_h1_text = mr_supported_h1.innerHTML;
            var mr_supported_close = mr_supported_div.querySelector(".mr_supported_close");
            mr_supported_close.addEventListener("click", function (e) {
                document.querySelector(".mr_supported_div").remove();
            });
            function build_content() {
                mr_supported_h1.innerHTML = mr_supported_h1_text.split("[num]").join(settings.sites.length);
                if (settings.update) {
                    var update = new Date(settings.update).toLocaleString();
                    mr_supported_update.innerHTML = mr_supported_update_text.split("[time]").join(update);
                } else {
                    mr_supported_update.innerHTML = "Click to Update";
                }
                mr_supported_list.innerHTML = "";
                settings.sites.forEach(site => {
                    var site_a = document.createElement("a");
                    site_a.href = site.domain;

                    var site_div = document.createElement("div");
                    var img = document.createElement("img");
                    img.setAttribute("crossorigin", "anonymous");
                    img.src = mindrender_domain + site.icon;
                    site_div.className = "mr_supported_list_item";
                    site_div.innerHTML = site.domain.split("/")[2];

                    site_div.prepend(img);
                    site_a.appendChild(site_div);
                    mr_supported_list.appendChild(site_a);
                });
            }
            build_content();

            mr_supported_update.addEventListener("click", function () {
                browser.runtime.sendMessage({ "action": "update_settings" }, (response) => {
                    settings = response.settings;
                    if (checkurl()) {
                        makestyle();
                    }
                    build_content();
                });
            });
        }
    });
}

function mr_getsettings() {
    //console.log("mr_getsettings");
    browser.runtime.sendMessage({ "action": "get_settings" }, (response) => {
        if (response.settings) {
            function waitingbody() {
                //console.log("waitingbody");
                if (document.body) {
                    mr_extension(response.settings);
                } else {
                    setTimeout(function () {
                        waitingbody();
                    }, 1000);
                }
            }
            waitingbody();
        } else {
            setTimeout(function () {
                mr_getsettings()
            }, 1000);
        }
    });
}
mr_getsettings();

